clear 
***read in data****
use "/home/cramer/lpd.dta"

***We also need to know what duration of unemployment those who transition from N or E report***
*log using tom_maker.log, replace

drop if lfs==-1
keep if mdate>=tm(2001m10)

keep if age>24 & age<=55


gen year=2001
forvalues i= 2002/2013 { 
	replace year = `i' if mdate>=tm(`i'm1) & mdate<=tm(`i'm12)
}

*drop if missing(udur) | udur<0
gen months_dur = floor(udur/4.01)
replace months_dur = 23 if months_dur>=23

***these are needed for the calibration***
gen zero_months_dur= (months_dur ==0)

gen six_months_dur = (months_dur==6)

gen seven_months_dur = (months_dur==7)


forvalues i = 2002/2013 {
***N to U***
tab zero_months_dur [aweight=sswgt] if lft==8 & year==`i'
}
stop
forvalues i = 2002/2013 {
tab six_months_dur [aweight=sswgt] if lft==8 & year==`i'
}
***E to U***
forvalues i = 2002/2013 {
tab zero_months_dur [aweight=sswgt] if lft==2 & year==`i'

}
forvalues i = 2002/2013 {
tab six_months_dur [aweight=sswgt] if lft==2 & year==`i'

}

***from these we make the thetas, see Kroft et al.****


****these are needed for the simulation****
forvalues i = 2008/2013 {
***N to U***
tab months_dur [aweight=sswgt] if lft==8 & year==`i'
***E to U***
tab months_dur [aweight=sswgt] if lft==2 & year==`i'
}

*****We will use 2008 forward in the simulation to put in the actual transition values****
*****These are inverted and put in columns 42 on for the nu transitions and 67 on for the eu transitions**** 
